library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity arithm_block is
        generic(n:integer := 16);   
    Port ( clk : in STD_LOGIC;
	       smand0 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand1 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand2 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand3 : in STD_LOGIC_VECTOR(n-1 downto 0);
		adder_enable : in STD_LOGIC;
		en_enable : out STD_LOGIC;
	       val_out : out STD_LOGIC_VECTOR(2*n-1 downto 0));
end arithm_block;

architecture behavior of arithm_block is
  signal psum1 : signed(n downto 0):=(others => '0'); --change if decimating squared signal
  signal psum2 : signed(n downto 0):=(others => '0'); --change if decimating squared signal
  signal psum3 : signed(n+1 downto 0):=(others => '0'); --change if decimating squared signal
  signal sq : signed(2*n+3 downto 0):=(others => '0'); --change if decimating squared signal


begin
  process (clk) 
  begin
    if (rising_edge(clk)) then
        if adder_enable='1' then
		psum1<=resize(signed(smand0)+signed(smand1),n+1);
		psum2<=resize(signed(smand2)+signed(smand3),n+1);
		psum3<=resize(psum1+psum2,n+2);
		sq<=psum3*psum3;
		val_out<=std_logic_vector(sq(2*n+3 downto 4));
		en_enable<=adder_enable;
	end if;
    end if;
  end process;
end behavior;